using UnityEngine;
using HutongGames.PlayMaker;

[ActionCategory("LV/Movement")]
[UnityEngine.Tooltip("Move an object from point A to B along a parabolic arc.")]
public class LvParabolicMovement : FsmStateAction
{
    [RequiredField]
    public FsmOwnerDefault targetObject;

    public FsmVector3 startPoint;
    public FsmVector3 endPoint;
    public FsmFloat arcHeight;
    public FsmFloat duration;

    private float time;
    private Transform target;
    private Vector3 p0, p1, p2;

    public override void Reset()
    {
        arcHeight = 2f;
        duration = 1f;
    }

    public override void OnEnter()
    {
        target = Fsm.GetOwnerDefaultTarget(targetObject).transform;
        time = 0f;

        p0 = startPoint.Value;
        p2 = endPoint.Value;
        p1 = Vector3.Lerp(p0, p2, 0.5f);
        p1.y += arcHeight.Value;
    }

    public override void OnUpdate()
    {
        time += Time.deltaTime;
        float t = Mathf.Clamp01(time / duration.Value);

        Vector3 a = Vector3.Lerp(p0, p1, t);
        Vector3 b = Vector3.Lerp(p1, p2, t);
        target.position = Vector3.Lerp(a, b, t);

        if (t >= 1f)
        {
            Finish();
        }
    }
}